﻿using System;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace PWS.API.Window.Sample6
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool SetWindowText(IntPtr hWnd, String lpString);

        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        [DllImport("user32.dll")]
        public static extern bool GetWindowText(IntPtr hWnd, StringBuilder lpString, int nMaxCount);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonChangeTitle_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = FindWindow("Notepad", null);
            if (!hWnd.Equals(IntPtr.Zero))
            {
                StringBuilder oldTitle = new StringBuilder(200);
                GetWindowText(hWnd, oldTitle, oldTitle.Capacity);
                if (SetWindowText(hWnd, "www.PayaWebShomal.com"))
                    MessageBox.Show(String.Format("Old Title= {0}, New Title = www.PayaWebShomal.com", oldTitle));
            }
        }
    }
}